/*
 * Decompiled with CFR 0.152.
 */
package de.diddiz.LogBlock;

import de.diddiz.LogBlock.Config;
import de.diddiz.LogBlock.LogBlock;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Level;

public class ClearLog
implements Runnable {
    private Connection conn;

    public ClearLog(Connection conn) {
        this.conn = conn;
    }

    @Override
    public void run() {
        if (this.conn == null) {
            return;
        }
        Statement state = null;
        try {
            try {
                state = this.conn.createStatement();
                for (String table : Config.worldTables) {
                    int deleted = state.executeUpdate("DELETE FROM `" + table + "` WHERE date < date_sub(now(), INTERVAL " + Config.keepLogDays + " DAY)");
                    if (deleted > 0) {
                        LogBlock.log.info("[LogBlock] Cleared out table " + table + ". Deleted " + deleted + " entries.");
                    }
                    if ((deleted = state.executeUpdate("DELETE `" + table + "-sign` FROM `" + table + "-sign` LEFT JOIN `" + table + "` ON (`" + table + "-sign`.`id` = `" + table + "`.`id`) WHERE `" + table + "`.`id` IS NULL;")) > 0) {
                        LogBlock.log.info("[LogBlock] Cleared out table " + table + "-sign. Deleted " + deleted + " entries.");
                    }
                    if ((deleted = state.executeUpdate("DELETE `" + table + "-chest` FROM `" + table + "-chest` LEFT JOIN `" + table + "` ON (`" + table + "-chest`.`id` = `" + table + "`.`id`) WHERE `" + table + "`.`id` IS NULL;")) <= 0) continue;
                    LogBlock.log.info("[LogBlock] Cleared out table " + table + "-chest. Deleted " + deleted + " entries.");
                }
            }
            catch (SQLException ex) {
                LogBlock.log.log(Level.SEVERE, "[LogBlock] SQL exception", ex);
                try {
                    if (state != null) {
                        state.close();
                    }
                    if (this.conn != null) {
                        this.conn.close();
                    }
                }
                catch (SQLException ex2) {
                    LogBlock.log.log(Level.SEVERE, "[LogBlock] SQL exception on close", ex2);
                }
            }
        }
        finally {
            try {
                if (state != null) {
                    state.close();
                }
                if (this.conn != null) {
                    this.conn.close();
                }
            }
            catch (SQLException ex) {
                LogBlock.log.log(Level.SEVERE, "[LogBlock] SQL exception on close", ex);
            }
        }
    }
}

